REBOL [
    subject: "Space Invaders"
    author: "Olivier Auverlot"
    version: 1.3
]

; CHARGEMENT DES GRAPHISMES ET SONS
; images stockes dans le tableau aliens-pic pour les ennemis
; le 5eme vaisseau correspond  la soucoupe
aliens-pic: []
for i 1 5 1 [
    append aliens-pic (load to-file join "monstre" [ i ".bmp" ])
]
; cration de l'image contenant les aliens
aliens: make image! 454x222

; chargement du canon
sprite-canon: load %canon.bmp

; chargement des sons
sounds: []

foreach son [
    %tir-joueur.wav 
    %tir-alien.wav 
    %explosion-alien.wav 
    %explosion-joueur.wav 
] [ append sounds (load son) ]


; ouverture du canal pour le son
if error? try [
    sndprt: open sound://
    son-actif: true    ; permet d'activer ou de dsactiver le son
    son-disponible: true    ; le joueur peut activer ou dsactiver le son
] [
    son-disponible: false
    son-actif: false
]

; aliens-layout
aliens-layout: layout/size [
    at 0x0
    aliens-buffer: image 454x222 effect [ draw [] ]           
] 454x222     

; redfinition de l'vnement close de la fentre
; permet de quitter proprement l'application
; fermeture du canal son
insert-event-func [
    if event/type = 'close [
        if son-disponible = true [
            close sndprt
        ]
        quit
    ] 
    event
]

presentation: layout [
    backtile 255.0.0 effect [ gradient  0x1 0.0.0 ]
    vh1 "Space Invaders"
    vh3 "Version 1.3"
    tabs 100
    across
    image aliens-pic/1 effect [ key 0.0.255 ]
    tab 
    vh2 "10 pts" return
    image aliens-pic/2 effect [ key 0.0.255 ]
    tab 
    vh2 "20 pts" return
    image aliens-pic/3 effect [ key 0.0.255 ]
    tab 
    vh2 "30 pts" return
    image aliens-pic/4 effect [ key 0.0.255 ]
    tab 
    vh2 "40 pts" return
    image aliens-pic/5 effect [ key 0.0.255 ]
    tab 
    vh2 "500 pts" return
    son: check 
    text "Son actif" white bold
    return
    button "Quitter" [ 
        if son-disponible = true [
            close sndprt
        ]
        quit
    ]
    button "Jouer" [
        either son-disponible = true [
            son-actif: son/data
        ] [ son-actif: false ]
        nouvelle-partie
    ]
    do [ son/data: son-actif ]
] 


ecran: layout [
    backdrop %fond.bmp
    origin 0x0
    
    panel 640x30 [ 
        backtile 0.0.0 effect [ gradient  0x1 255.0.0 ]
        origin 0x0
        across
        tabs [ 80 400 ]
        tab
        vh1 "Space Invaders"
        tab
        vh1 "Score:"
        score-text: vh1 "00000"
    ]
 
    affichage: box 640x480 rate 0:0:0.1 feel [
        detect: func [ face event ] [
            switch event/type [
                move [ deplace-canon: event/offset/x ]
                down [ lance-missile ]
            ]
        ]
        engage: func [f a e] [
            if a = 'time [ gestion-ecran ]
        ]
    ] effect [ draw [] ]
] 

; rendu acclr pour les lments transparents
affichage/saved-area: true

nouveau-stage: does [
    pos-canon: 296x430  ; position du canon
    deplace-canon: 0    ; position X vers laquelle se place le canon

    pos-tir-canon: 0x0  ; position du tir du canon
    tir-canon: false    ; un missile est lanc par le joueur
    
    nbr-aliens-touches: 0    ; nombre d'aliens touchs par le joueur
    pos-aliens: 10x48       ; position des aliens sur l'cran
    deplacement-aliens: 10  ; incrmentation du dplacement des aliens
    tirs-aliens: copy []    ; tirs des aliens

    passage-soucoupe: false     ; passage d'une soucoupe ?
    pos-soucoupe: 0x0  ; position de la soucoupe sur l'cran
    ; tab-ennemis contient les diffrents vaiseaux 
    ; numrots de 4  1 (8 vaisseaux sur 4 lignes)
    tab-ennemis: copy []
    for i 1 4 1 [
        ligne: copy []
        insert/dup ligne i 8
        insert/only tab-ennemis ligne
    ]

    aliens: copy genere-ennemis
    aliens-buffer/image: copy aliens
    aliens-buffer/effect/draw: copy [
        'pen 0.0.255 
        'fill-pen 0.0.255
    ]
    view/title ecran "Space Invaders"
]

nouvelle-partie: does [
    score: 0                 ; score du joueur

    nbr-tirs-max: 5    ; nombre maximum de tirs par les aliens
    
    deplacement-soucoupe: 15    ;incrmentation de la soucoupe
            
    score-text/text: copy "00000"    ; le score est mis  0
    nouveau-stage
]


; formatage du score sur 5 caractres
formate-score: does [
    use [ str ] [
        str: to-string score
        return insert/dup (head str) "0" (5 - (length? str))     
    ]    
]


ajoute-score: function [ valeur ] [] [
    play-sound 3
    score: score + valeur
    if score > 99999 [ score: 0 ]
    score-text/text: formate-score
    show score-text    
]


; generation de l'image contenant les vaisseaux ennemis
genere-ennemis: does [
    use [ pxy i sprite sp-layout display ] [
        sp-layout: layout/size [
            at 0x0
            display: box 454x222 0.0.255 effect [
                draw []
            ]
        ] 454x222
        pxy: 0x0
        for i 4 1 -1 [
            sprite: copy aliens-pic/:i
            loop 8 [
                append display/effect/draw reduce [
                    'image pxy sprite 0.0.255
                ]
                pxy/x: pxy/x + 58
            ]
            pxy/x: 0
            pxy/y: pxy/y + 58
        ]
        return (make image! sp-layout)
   ]
]

; dclencle le lancement d'un tir du joueur
; un seul tir est autoris  la fois
lance-missile: does [
    if tir-canon = false [ 
        play-sound 1 
        tir-canon: true 
        pos-tircanon: make pair! reduce [ 
            pos-canon/x + 13
            430
        ]
    ]
]

; un son est envoy  la carte sonore
play-sound: function [ num ] [ ] [
    if son-actif = true [
        insert sndprt sounds/:num
    ]
]

; gestion des vnements
gestion-ecran: does [
    ; on efface les lments affichs
    clear affichage/effect/draw
    
    ; mouvement du canon
    either pos-canon/x > deplace-canon [ 
        pos-canon/x: pos-canon/x - 5 
    ] [    
        pos-canon/x: pos-canon/x + 5
    ]
    append affichage/effect/draw reduce [ 
        'image pos-canon sprite-canon 0.0.255 
    ]    
          
    ; dplacement des aliens
    ; ----------------------
    pos-aliens/x: pos-aliens/x + deplacement-aliens
    if any [ 
	    ((pos-aliens/x + 454) >= 630)
        (pos-aliens/x <= 10)
	] [ 
        deplacement-aliens: negate deplacement-aliens
        if pos-aliens/y < 200 [
            pos-aliens/y: pos-aliens/y + 5
        ]
    ]
    append affichage/effect/draw reduce [
        'image pos-aliens aliens 0.0.255
    ]
    
    ; gestion d'une soucoupe
    ; ----------------------
    either (passage-soucoupe = true) [
        pos-soucoupe/x: pos-soucoupe/x + incrementation-soucoupe
        either (incrementation-soucoupe > 0) [
            ; deplacement vers la droite
            if pos-soucoupe/x > 620 [
                passage-soucoupe: false
            ]
        ] [
           ; deplacement vers la gauche
            if pos-soucoupe/x < 20 [
                passage-soucoupe: false
            ]
        ]
        append affichage/effect/draw reduce [
            'image pos-soucoupe aliens-pic/5 0.0.255
        ]
    ] [
        ; doit-on afficher une soucoupe ?
        if (random 100) = 50 [ 
            passage-soucoupe: true
            ; on dtermine la direction        
            either (random 2) = 1 [ 
                ; dplacement vers la droite
                incrementation-soucoupe: 20
                pos-soucoupe/x: 20
            ] [
                ; deplacement vers la gauche
                incrementation-soucoupe: -20
                pos-soucoupe/x: 620
            ]
        ] 
    ]

    ; tir du canon
    ; ------------
    if tir-canon = true [
        either pos-tircanon/y > 30 [
            pos-tircanon/y: pos-tircanon/y - 20
            append affichage/effect/draw reduce [
                'pen 255.0.0
                'fill-pen 255.0.0
                'box pos-tircanon (pos-tircanon + 6x12)
            ]              
            ; test de collision du missile
            decalage: pos-tircanon - pos-aliens
            decx: (make integer! decalage/x / 58) + 1
            decy: (make integer! decalage/y / 58) + 1                    
            if all [
                (decx >= 1)
                (decx <= 8)
                (decy >= 1)
                (decy <= 4)
            ] [
                ; on cherche un vaisseau  cette position
                vaisseau: tab-ennemis/:decy/:decx
                if vaisseau <> 0 [
                    ; un vaisseau est trouv
                    ; on efface le vaisseau de la grille
                    poke (pick tab-ennemis decy) decx 0
                    ; on efface le vaisseau de l'cran
                    xyv-deb: make pair! reduce [ 
                        ((decx - 1) * 58) 
                        ((decy - 1) * 58) 
                    ]
                    
                    ; le vaisseau est effac
                    ; on construit une image temporaire qui est
                    ; ensuite recopie dans aliens                           
                    append aliens-buffer/effect/draw reduce [  
                        'box xyv-deb (xyv-deb + 58x58)
                    ]                  
                    aliens: copy make image! aliens-layout  
                    
                    ; modification du score                 
                    ajoute-score (vaisseau * 10)
                    ; mise  jour du nombre d'aliens touchs
                    nbr-aliens-touches: nbr-aliens-touches + 1
                    if nbr-aliens-touches = 32 [
                        ; fin du stage
                        inform layout [
                            backtile 255.0.0 effect [ 
                                gradient  0x1 0.0.0 
                            ]    
                            vh1 "Une nouvelle vague arrive !"
                            button "Continuer" [ 
                                if nbr-tirs-max < 10 [
                                    ; on rend le jeu plus difficile
                                    nbr-tirs-max: nbr-tirs-max + 1
                                ]
                                hide-popup 
                                nouveau-stage
                            ]
                        ]
                    ]
                    tir-canon: false  
                ]
            ]              
            ; touche-t'on la soucoupe ?
            if passage-soucoupe = true [
                ; le test n'est utile que si le missile
                ; du joueur est en haut de l'cran
                if pos-tircanon/y <= 48 [
                    if all [
                        (pos-tircanon/x >= pos-soucoupe/x)
                        (pos-tircanon/x <= (pos-soucoupe/x + 48))
                    ] [
                        ; la soucoupe est touche
                        ; disparition de la soucoupe
                        passage-soucoupe: false
                        ; modification du score
                        ajoute-score 500
                        tir-canon: false  
                    ]
                ]
            ]
        ] [
            tir-canon: false
        ]
    ]    
    
    ; tir des ennemis
    ; ---------------
    ; un aliens veut-il tirer sur le joueur ?
    if (length? tirs-aliens) < nbr-tirs-max [
        if (colonne: random 100) <= 8 [
            ; un alien de la colonne veut tirer
            ; on recherche le premier disponible en partant du bas
            vaisseau: 0
            ligne: 4               
            until [
                vaisseau: tab-ennemis/:ligne/:colonne
                ligne: ligne - 1           
                any [ 
                    (ligne = 0) 
                    (vaisseau <> 0)
                ]
            ]
            if vaisseau <> 0 [
                ; on a trouv un vaisseau
                ; on dtermine les coordonnes de dpart
                ; du tir
                depart-tir: make pair! reduce [
                    pos-aliens/x + ((colonne - 1) * 58) + 26
                    ; on utilise (ligne + 1) (et non pas ligne plus 1)
                    ; pour annuler l'effet de la dcrmentation lors
                    ; de la recherche et placer le tir  la base de l'alien
                    (pos-aliens/y + ((ligne + 1) * 58))
                ]
                append tirs-aliens depart-tir
                play-sound 2
            ]
        ]
    ]
    
    ; animation des tirs des ennemis
    ; ------------------------------
    tirs-aliens: head tirs-aliens
    if (length? tirs-aliens) > 0 [
        ; on initialise le trac avec du blanc
        append affichage/effect/draw reduce [
            'pen 255.255.255
            'fill-pen 255.255.255
        ]
        until [
            tir: first tirs-aliens
            either tir/y <= 480 [
                tir/y: tir/y + 5
                change tirs-aliens tir
                append affichage/effect/draw reduce [
                   'box tir (tir + 6x6)
                ]
                ; le tir touche-t'il le joueur ?
                if tir/y >= 422 [
                    if all [
                        (tir/x >= pos-canon/x)
                        (tir/x <= (pos-canon/x + 48))
                    ] [   
                        ; le joueur a perdu
                        play-sound 4
                        inform layout [
                            backtile 255.0.0 effect [ gradient  0x1 0.0.0 ]    
                            vh1 "GAME OVER !"
                            button "Nouvelle partie" [ 
                                hide-popup 
                                view/title presentation "Space Invaders"
                            ]
                        ]                                                                
                    ]
                ]                
            ] [ remove tirs-aliens ]
            tirs-aliens: next tirs-aliens
            (tail? tirs-aliens)
        ] 
    ]
    show affichage
]


view/title presentation "Space Invaders"

